/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.service.converter;

import java.util.Date;

import org.springframework.core.convert.converter.Converter;

import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;
import gov.va.med.mhv.usermgmt.data.model.DirectMessage;

/**
 * @author vhaislegberb
 *
 */
public class DirectMessageDTOConverter implements Converter<DirectMessage, DirectMessageDTO> {

	@Override
	public DirectMessageDTO convert(DirectMessage src) {
		DirectMessageDTO dest = new DirectMessageDTO();
		
		dest.setCreatedDate(src.getCreatedDate() != null ? new Date(src.getCreatedDate().getTime()) : null);
		dest.setDirectMessageId(src.getDirectMessageId());
		dest.setDirectMessageStatus(src.getDirectMessageStatus());
		dest.setMessageId(src.getMessageId());
		dest.setModifiedDate(src.getModifiedDate() != null ? new Date(src.getModifiedDate().getTime()) : null);
		dest.setSentToEmailAddress(src.getSentToEmailAddress());
		dest.setUserProfileId(src.getUserProfileId());
		
		return dest;
	}

}
